#version 140
#extension GL_EXT_gpu_shader4 : enable

// Logarithmic Mobius TransformMod01.fsh by shane
//https://www.shadertoy.com/view/4dcSWs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed* 0.3141592
#define iResolution u_WindowSize

#define iMouse vec4(0.0,0.0, 0.0,0.0)
vec4 texture2D_Fract(sampler2D sampler,vec2 P)
 { return texture2D(sampler,fract(P));
 }

uniform sampler2D iChannel0;







/*

    Logarithmic Mobius Transform
	----------------------------

	Pretty standard Mobius transform, followed by a spiral zoom. I've always liked 
	this particular combination, and so do plenty of others, since it's used to
	produce a lot of the interesting geometric pictures you see all over the net.

	This particular example is based off of a couple of snippets I came across in 
	Flexi and Dila's code... I think. I can't quite remember where it came from.

*/

// Standard 2D rotation formula.
mat2 rot2(in float a){ float c = cos(a), s = sin(a); return mat2(c, -s, s, c); }

// Standard Mobius transform: f(z) = (az + b)/(cz + d). Slightly obfuscated.
// You could use a 2x2 matrix tranformation as well, if you wanted.
vec2 Mobius(vec2 p, vec2 z1, vec2 z2){
 

	z1 = p - z1; p -= z2;
	return vec2(dot(z1, p), z1.y*p.x - z1.x*p.y)/dot(p, p);
    // Hacky triple spiral -- There are better ways.
    //return vec2(dot(z1, p), z1.y*p.x - z1.x*p.y) / dot(p, p) - p*6.;
}

// Standard spiral zoom.
vec2 spiralZoom(vec2 p, vec2 offs, float n, float spiral, float zoom, vec2 phase){
	
	p -= offs;
	float a = atan(p.y, p.x)/6.2831; // Bringing it back to integer range.
	float d = log(length(p));
	return vec2(a*n + d*spiral, -d*zoom + a) + phase;
}

// Antialiased shape. The coordinates are mutated, so "fwidth" is used for
// concise, gradient-related, edge smoothing.
float shape(vec2 p) {
    
    // Hacky alternating column offset -- Mandatory with the hexagon.
    if(mod(p.x, 2.)<1.) p.y += .5; 
    // Local coordinates.
    p = fract(p) - .5;
    //float d = length(p); // Circle.
    //float d = max(abs(p.x), abs(p.y)); // Square bound.
    float d = max(abs(p.x)*.8660254 + abs(p.y)*.5, abs(p.y)); // Hexagon bound.
    //d = .4 - d; // Just the shape.
    d = min(.4 - d, (length(p) - .15)); // The shape with a hole cut out.
    return smoothstep(0., fwidth(d), d);
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{

    // Screen coordinates.
	vec2 uv = (gl_FragCoord.xy - iResolution.xy*.5)/iResolution.y;
    
    // Rotation and scaling.
    uv = rot2(3.14159/6.*sin(iTime/3.))*uv*1.5;
    
    
    // Hacky depth shading, but it works. :)
    //
    // Singularities controlled by the offset vectors below.
    float r = length(uv - vec2(.5, 0)); 
    r = min(r, length(uv - vec2(-.5, 0))); // Left - Controlled by the left offset below.

    
    // Transform the screen coordinates.
    //
    // Mobius.
    uv = Mobius(uv, vec2(-1, -.5), vec2(.5, 0));
    // Spiral zoon.
    uv = spiralZoom(uv, vec2(-.5), 5., 3.14159*.2, .5, vec2(-1, 1)*iTime*.125);
    
  
    
    // Draw a repeat grid pattern with the transformed coordinates.
    // We're using an even number, 4,  here, but even using odd factors, you'll 
    // have to change the spiral zoom factor (it's 5, at the moment) to something
    // even. Otherwise the pattern will be out of sync at the seam line.
    gl_FragColor = vec4(sqrt(vec3(shape(uv*4.)*min(r*1.5, 1.))), 1);
    //gl_FragColor = texture(iChannel0, uv); // Texture, if desired.
}
